Attribute VB_Name = "Test"
Option Explicit


Private mi_View As Integer
Private mb_TestChange As Boolean
Private mb_TestLoad As Boolean



Global gs_SO_UPDRigth() As String
Global gb_TestCanUpd As Boolean
Global gi_TestProdView As Integer
Global gs_View As String
Global gi_iConcurrency As Integer


Global gi_TestCode As Integer ' record the code of the test selected in the outline
Global gs_FullTestNumber As String ' record the description of the test
Global gs_CodeCategory As String ' record the code of the category of the test selected in the outline
Global gs_Category As String ' record the description of the category of the test selected in the outline


Public Const TEST_REAL As Integer = 1
Public Const TEST_ASSESSMENT As Integer = 2
Public Const TEST_OPINION_ONREAL As Integer = 3
Public Const TEST_OPINION_ONASSESSMENT As Integer = 4
Public Const TEST_OPINION_ONNOTHING As Integer = 5
Global gi_TestType As Integer 'record the type of test that the user is working on



'array for results (index begin at 1)
Global gv_result(1 To 100, 1 To 5) As Variant
'number of result in tab : 1 to 5
Global gi_nbresult As Integer

Public Sub GetTestSecurity()
'------------------------------------------------------------------
' Name : GetTestSecurity
'
' Purpose : Get all Sales office in which the user have update right
'           Fill gs_SO_UPDRigth with all sales office in which the user have update right
'
'
' Parameters : None
' Return values : None
'
'
' review : Jan/31/2000 by JJB
'------------------------------------------------------------------


Dim ls_Req As String 'temporary variable that record sql requests
Dim ll_Statement As Long ' record ODBC statement
Dim li_status As Integer 'record the code returned by ODBC procedures
ReDim gs_SO_UPDRigth(0)

On Error GoTo suite

ls_Req = "EXEC Test_Security_SO_UPDRight_sel "
If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
    Do While li_status = SQL_SUCCESS Or li_status = SQL_SUCCESS_WITH_INFO
        li_status = SQLFetch(ll_Statement)
        If li_status = SQL_SUCCESS Or li_status = SQL_SUCCESS_WITH_INFO Then
            ReDim Preserve gs_SO_UPDRigth(UBound(gs_SO_UPDRigth, 1) + 1)
            gs_SO_UPDRigth(UBound(gs_SO_UPDRigth, 1)) = ODBCData(ll_Statement, 1)
        End If
    Loop
End If
li_status = SQLFreeStatement(ll_Statement, SQL_DROP)
Exit Sub

suite:
li_status = SQLFreeStatement(ll_Statement, SQL_DROP)
StdError
End Sub

'------------------------------------------------------------------
' Name : Test_DefaultView
'
' Purpose : This procedure is called at the beginning and when we want
'           no view.
'
' Parameters : Nothing
'
' review : Jan/28/2000 by JJB
'------------------------------------------------------------------
'Public Sub Test_DefaultView()
'    mi_View = frmMain.TestOutLine.i_DefaultView
'End Sub


'------------------------------------------------------------------
' Name : Test_ChangeView
'
' Purpose : This procedure is called when outline component indicates
'           that an other view is requiered. This procedure unload all
'           other view and load the good view.
'
' Parameters :
'       li_view     number that indicate the view to load
'       li_left     indicate the left position of the view
'       li_top      indicate the top position of the view
'
' review : Jan/28/2000 by JJB
'------------------------------------------------------------------
'Public Sub Test_ChangeView(ByVal li_View As Integer, ByVal li_Left As Integer, ByVal li_top As Integer)
'
'    'mi_View = li_View
'On Error GoTo Err_UnLoad
'        Unload TestGen
'        Unload TestCnd
'        Unload TestRes
'        Unload TestProd
'        Unload TestDoc
'On Error GoTo 0
'
'    If mi_View = -1 Then
'        Test_DefaultView
'    Else
'        If li_View > 0 Then
'            mi_View = li_View
'        Else
'            Exit Sub
'        End If
'    End If
'
'    Select Case mi_View
'        Case 1
'            TestGen.mi_LeftForm = li_Left
'            TestGen.mi_TopForm = li_top
'            TestGen.show
'            SetOwner TestGen.hwnd, frmMain.TestOutLine.l_FormHandle
'        Case 2
'            TestCnd.mi_LeftForm = li_Left
'            TestCnd.mi_TopForm = li_top
'            TestCnd.show
'            SetOwner TestCnd.hwnd, frmMain.TestOutLine.l_FormHandle
'        Case 3
'            TestRes.mi_LeftForm = li_Left
'            TestRes.mi_TopForm = li_top
'            TestRes.show
'            SetOwner TestRes.hwnd, frmMain.TestOutLine.l_FormHandle
'        Case 4
'            TestProd.mi_LeftForm = li_Left
'            TestProd.mi_TopForm = li_top
'            TestProd.show
'            SetOwner TestProd.hwnd, frmMain.TestOutLine.l_FormHandle
'        Case 5
'            TestDoc.mi_LeftForm = li_Left
'            TestDoc.mi_TopForm = li_top
'            TestDoc.show
'            SetOwner TestDoc.hwnd, frmMain.TestOutLine.l_FormHandle
'    End Select
'Err_UnLoad:
'End Sub


'------------------------------------------------------------------
' Name : Test_Change
'
' Purpose : Execute when the outline indicates that the Test
'           has change. Change the code and description in the
'           global variables to indicate the new Test code.
'
' Parameters :
'       ls_QuotCode   Quotation Identifier
'       ls_QuotDesc   Quotation Description (User code)
'       li_Left       Indicates the left position of the view
'       li_Top        Indicates the top position of the view
'
' review : Jan/28/2000 by JJB
'------------------------------------------------------------------
'Public Sub Test_Change(ls_TestCode As String, ls_TestDesc As String, li_Left As Integer, li_top As Integer, Optional li_View)
'Dim ls_Req As String
'Dim li_Status As Integer
'Dim ll_Statement As Long

'    On Error GoTo Test_Change_Err
        
'    gi_TestCode = CInt(ls_TestCode)
'    gs_FullTestNumber = ls_TestDesc
'    mb_TestChange = OK

'    If IsMissing(li_View) Then
'        frmMain.TestOutLine.ChangeView mi_View
'        Test_ChangeView mi_View, li_Left, li_top
'    Else
'        frmMain.TestOutLine.ChangeView li_View
'        Test_ChangeView li_View, li_Left, li_top
'    End If
        
'    Exit Sub
    
'Test_Change_Err:
'    StdError
'End Sub


Public Sub SetTestCode(ByVal aTestCode As Long)
    gi_TestCode = aTestCode
    mb_TestChange = True
End Sub



'------------------------------------------------------------------
' Name : Test_UpdateCommonInformation
'
' Purpose : Update all the common informations with the Test
'           code. This procedure is call when the user call a view.
'
' Parameters :
'       None
'
' Return :
'       OK      The information have been updated
'       KO      The information havn't be updated
'
' review : Jan/31/2000 by JJB
'------------------------------------------------------------------
Public Function Test_UpdateCommonInformation() As Boolean
Dim ls_Req As String
Dim li_status As Integer
Dim ll_Statement As Long
Dim ls_CodeSalesOffice As String

    On Error GoTo Test_UpdateCommonInformation_Err
    Test_UpdateCommonInformation = KO
    
    'if it's not a new Test, we exit
    If mb_TestChange = KO Then
        Test_UpdateCommonInformation = OK
        Exit Function
    End If
    
    'Read Additionnal information about the test
    ls_Req = "exec Test_t_sel " & CStr(gi_TestCode) & ",'" & gut_LangLogin.Code & "'"
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Req) Then
        li_status = SQL_SUCCESS
        Do While li_status = SQL_SUCCESS Or li_status = SQL_SUCCESS_WITH_INFO
        ' Get the row of data
            li_status = SQLFetch(ll_Statement)
            If li_status = SQL_SUCCESS Or li_status = SQL_SUCCESS_WITH_INFO Then
                gi_TestType = ODBCData(ll_Statement, 1)
                gs_CodeCategory = ODBCData(ll_Statement, 2)
                gs_Category = ODBCData(ll_Statement, 3)
                ls_CodeSalesOffice = ODBCData(ll_Statement, 4)
            End If
            CheckTestSecurity (ls_CodeSalesOffice)
            Test_UpdateCommonInformation = OK
        Loop
    
    
        mb_TestChange = KO
    End If
    li_status = SQLFreeStatement(ll_Statement, SQL_DROP)
    
    Exit Function
    
Test_UpdateCommonInformation_Err:
    li_status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError

End Function


Public Sub CheckTestSecurity(ByVal ls_CodeSalesOffice As String)
'------------------------------------------------------------------
' Name : CheckTestSecurity
'
' Purpose : Return true if the user can update test based on this sales office
'
' Parameters :
'       ls_CodeSalesOffice : code of the sales office to check security
'
' Return :
'       OK      The user can update
'       KO      The user can't
'
' review : Jan/31/2000 by JJB
'------------------------------------------------------------------

Dim li_Count As Integer
    gb_TestCanUpd = KO
    For li_Count = 0 To UBound(gs_SO_UPDRigth, 1)
        If gs_SO_UPDRigth(li_Count) = ls_CodeSalesOffice Then
            gb_TestCanUpd = OK
        End If
    Next
End Sub



'Public Sub OutlineAddTest(ByVal ls_TestCode As String, ByVal ls_TestDesc As String)
'------------------------------------------------------------------
' Name : OutlineAddTest
'
' Purpose : Tell to the outline to add a new test in the tree
'
' Parameters :
'       ls_TestCode : code of the new test to add
'       ls_TestDesc : Description of the new test to add
'
'
' review : Jan/31/2000 by JJB
'------------------------------------------------------------------

'    frmMain.TestOutLine.LocalAddItem ls_TestCode, ls_TestDesc
'End Sub


'Public Sub OutlineUpdTest(ByVal ls_TestCode As String, ByVal ls_TestDesc As String)
'------------------------------------------------------------------
' Name : OutlineUpdTest
'
' Purpose : Tell to the outline to update the position and the description of a test in the tree
'
' Parameters :
'       ls_TestCode : code of the test to update
'       ls_TestDesc : Description of the updated test
'
'
' review : Jan/31/2000 by JJB
'------------------------------------------------------------------

'    frmMain.TestOutLine.LocalDelItem ls_TestCode
'    frmMain.TestOutLine.LocalAddItem ls_TestCode, ls_TestDesc
'End Sub


'Public Sub OutlineDelTest(ByVal ls_TestCode As String)
'------------------------------------------------------------------
' Name : OutlineDelTest
'
' Purpose : Tell to the outline to remove a test from the tree
'
' Parameters :
'       ls_TestCode : code of the test to remove
'
'
' review : Jan/31/2000 by JJB
'------------------------------------------------------------------

'    frmMain.TestOutLine.LocalDelItem ls_TestCode
'End Sub


'Public Sub Test_OutlineWithoutViewAdd(ByVal li_OptionNumber As Integer)
'Dim li_CurrTestType As Integer
''MouseOff
'li_CurrTestType = gi_TestType
'gs_Action = "Add"
'
'Select Case li_OptionNumber
'Case 0
'    gb_Return = KO
'    gi_TestType = TEST_REAL
'    TestGen_mtnc.show 1
'    SetOwner TestGen_mtnc.hwnd, frmMain.TestOutLine.l_FormHandle
'    If gb_Return Then
'         OutlineAddTest gi_TestCode, gs_FullTestNumber
'    Else
'        gi_TestType = li_CurrTestType
'    End If
    
'Case 1
'    gb_Return = KO
'    gi_TestType = TEST_OPINION_ONNOTHING
'    TestGen_mtnc.show 1
'   ' SetOwner TestGen_mtnc.hwnd, FrmMain.TestOutLine.l_FormHandle
'    If gb_Return Then
'        OutlineAddTest gi_TestCode, gs_FullTestNumber
'    Else
'        gi_TestType = li_CurrTestType
'    End If
'
'End Select
'MouseOn

'End Sub
